/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.forge;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import icyllis.modernui.ModernUI;
import icyllis.modernui.core.Core;
import icyllis.modernui.core.Handler;
import icyllis.modernui.fragment.FragmentController;
import icyllis.modernui.graphics.ImageStore;
import icyllis.modernui.mc.BlurHandler;
import icyllis.modernui.mc.FontResourceManager;
import icyllis.modernui.mc.GuiRenderType;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.OptiFineIntegration;
import icyllis.modernui.mc.UIManager;
import icyllis.modernui.mc.forge.Config;
import icyllis.modernui.mc.forge.MenuScreenFactory;
import icyllis.modernui.mc.forge.MuiRegistries;
import icyllis.modernui.mc.forge.NetworkHandler;
import icyllis.modernui.mc.forge.NetworkMessages;
import icyllis.modernui.mc.forge.OpenMenuEvent;
import icyllis.modernui.mc.forge.ProjectBuilderItem;
import icyllis.modernui.mc.forge.ProjectBuilderModel;
import icyllis.modernui.mc.forge.ServerHandler;
import icyllis.modernui.mc.forge.UIManagerForge;
import icyllis.modernui.mc.mixin.AccessOptions;
import icyllis.modernui.mc.testforge.TestContainerMenu;
import icyllis.modernui.mc.testforge.TestPauseFragment;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.io.output.StringBuilderWriter;

@Mod.EventBusSubscriber(modid="modernui", bus=Mod.EventBusSubscriber.Bus.MOD)
final class Registration {
    private Registration() {
    }

    @SubscribeEvent
    static void register(@Nonnull RegisterEvent event) {
        if (ModernUIMod.sDevelopment) {
            event.register(ForgeRegistries.MENU_TYPES.getRegistryKey(), Registration::registerMenus);
            event.register(ForgeRegistries.ITEMS.getRegistryKey(), Registration::registerItems);
        }
    }

    static void registerMenus(@Nonnull RegisterEvent.RegisterHelper<MenuType<?>> helper) {
        helper.register(MuiRegistries.TEST_MENU_KEY, (Object)IForgeMenuType.create(TestContainerMenu::new));
    }

    static void registerItems(@Nonnull RegisterEvent.RegisterHelper<Item> helper) {
        Item.Properties properties = new Item.Properties().m_41487_(1);
        helper.register(MuiRegistries.PROJECT_BUILDER_ITEM_KEY, (Object)new ProjectBuilderItem(properties));
    }

    @SubscribeEvent
    static void setupCommon(@Nonnull FMLCommonSetupEvent event) {
        if (ModList.get().getModContainerById(new String(new byte[]{107, 73, 119, 105}, StandardCharsets.UTF_8).toLowerCase(Locale.ROOT)).isPresent()) {
            event.enqueueWork(() -> ModernUI.LOGGER.fatal("OK"));
        }
        if (ModernUIMod.sDevelopment) {
            NetworkMessages.sNetwork = (NetworkHandler)DistExecutor.safeRunForDist(() -> NetworkMessages::client, () -> NetworkMessages::new);
        }
        MinecraftForge.EVENT_BUS.register((Object)ServerHandler.INSTANCE);
    }

    static class ModClientDev {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ModClientDev() {
        }

        @SubscribeEvent
        static void onRegistryModel(@Nonnull ModelEvent.RegisterAdditional event) {
            event.register(ModernUIMod.location("item/project_builder_main"));
            event.register(ModernUIMod.location("item/project_builder_cube"));
        }

        @SubscribeEvent
        static void onBakeModel(@Nonnull ModelEvent.ModifyBakingResult event) {
            Map registry = event.getModels();
            ModClientDev.replaceModel(registry, new ModelResourceLocation("modernui", "project_builder", "inventory"), baseModel -> new ProjectBuilderModel((BakedModel)baseModel, event.getModels()));
        }

        private static void replaceModel(@Nonnull Map<ResourceLocation, BakedModel> modelRegistry, @Nonnull ModelResourceLocation location, @Nonnull Function<BakedModel, BakedModel> replacer) {
            modelRegistry.put((ResourceLocation)location, replacer.apply(modelRegistry.get(location)));
        }

        static {
            boolean bl = $assertionsDisabled = !Registration.class.desiredAssertionStatus();
            if (!$assertionsDisabled && !FMLEnvironment.dist.isClient()) {
                throw new AssertionError();
            }
        }
    }

    @Mod.EventBusSubscriber(modid="modernui", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    static class ModClient {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ModClient() {
        }

        @SubscribeEvent
        static void loadingClient(RegisterParticleProvidersEvent event) {
            UIManagerForge.initialize();
        }

        @SubscribeEvent
        static void registerResourceListener(@Nonnull RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> {
                ImageStore.getInstance().clear();
                Handler handler = Core.getUiHandlerAsync();
                if (handler != null) {
                    handler.post(() -> UIManager.getInstance().updateLayoutDir((Boolean)Config.CLIENT.mForceRtl.get()));
                }
                BlurHandler.INSTANCE.loadEffect();
            }));
            if (!ModernUIMod.isTextEngineEnabled()) {
                event.registerReloadListener((PreparableReloadListener)FontResourceManager.getInstance());
            }
            ModernUI.LOGGER.debug(ModernUI.MARKER, "Registered resource reload listener");
        }

        @SubscribeEvent
        static void registerKeyMapping(@Nonnull RegisterKeyMappingsEvent event) {
            event.register(UIManagerForge.OPEN_CENTER_KEY);
            event.register(UIManagerForge.ZOOM_KEY);
        }

        @SubscribeEvent
        static void setupClient(@Nonnull FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                UIManagerForge.initializeRenderer();
                Config.CLIENT.mLastWindowMode.apply();
                if (ModernUIMod.sDevelopment) {
                    MenuScreens.m_96206_((MenuType)((MenuType)MuiRegistries.TEST_MENU.get()), MenuScreenFactory.create(menu -> new TestPauseFragment()));
                }
            });
            CrashReportCallables.registerCrashCallable((String)"Fragments", () -> {
                FragmentController fragments = UIManager.getInstance().getFragmentController();
                StringBuilder builder = new StringBuilder();
                if (fragments != null) {
                    try (PrintWriter pw = new PrintWriter((Writer)new StringBuilderWriter(builder));){
                        fragments.getFragmentManager().dump("", null, pw, new String[0]);
                    }
                }
                return builder.toString();
            }, () -> UIManager.getInstance().getFragmentController() != null);
            if (((Boolean)Config.CLIENT.mUseNewGuiScale.get()).booleanValue()) {
                OptionInstance newGuiScale = new OptionInstance("options.guiScale", OptionInstance.m_231498_(), (caption, value) -> {
                    int r = MuiModApi.calcGuiScales();
                    if (value == 0) {
                        int auto = r >> 4 & 0xF;
                        return Options.m_231921_((Component)caption, (Component)Component.m_237115_((String)"options.guiScale.auto").m_7220_((Component)Component.m_237113_((String)(" (" + auto + ")"))));
                    }
                    MutableComponent valueComponent = Component.m_237113_((String)value.toString());
                    int min = r >> 8 & 0xF;
                    int max = r & 0xF;
                    if (value < min || value > max) {
                        MutableComponent hint = value < min ? Component.m_237113_((String)(" (<" + min + ")")) : Component.m_237113_((String)(" (>" + max + ")"));
                        valueComponent.m_7220_((Component)hint);
                        valueComponent.m_130940_(ChatFormatting.RED);
                    }
                    return Options.m_231921_((Component)caption, (Component)valueComponent);
                }, (OptionInstance.ValueSet)new GuiScaleValueSet(), (Object)0, value -> Minecraft.m_91087_().m_6937_(() -> {
                    Minecraft minecraft = Minecraft.m_91087_();
                    if ((int)minecraft.m_91268_().m_85449_() != minecraft.m_91268_().m_85385_(value.intValue(), false)) {
                        minecraft.m_5741_();
                    }
                }));
                Options options = Minecraft.m_91087_().f_91066_;
                newGuiScale.m_231514_((Object)((Integer)options.m_231928_().m_231551_()));
                ((AccessOptions)options).setGuiScale((OptionInstance<Integer>)newGuiScale);
                if (ModernUIMod.isOptiFineLoaded()) {
                    OptiFineIntegration.setGuiScale((OptionInstance<Integer>)newGuiScale);
                    ModernUI.LOGGER.debug(ModernUI.MARKER, "Override OptiFine Gui Scale");
                }
            }
        }

        @SubscribeEvent
        static void onMenuOpen(@Nonnull OpenMenuEvent event) {
            AbstractContainerMenu abstractContainerMenu;
            if (ModernUIMod.sDevelopment && (abstractContainerMenu = event.getMenu()) instanceof TestContainerMenu) {
                TestContainerMenu c = (TestContainerMenu)abstractContainerMenu;
                event.set(new TestPauseFragment());
            }
        }

        @SubscribeEvent
        static void onRegisterShaders(@Nonnull RegisterShadersEvent event) {
            try {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ModernUIMod.location("rendertype_modern_tooltip"), DefaultVertexFormat.f_85814_), GuiRenderType::setShaderTooltip);
            }
            catch (IOException e) {
                ModernUI.LOGGER.error(ModernUI.MARKER, "Bad tooltip shader", (Throwable)e);
            }
            try {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ModernUIMod.location("rendertype_round_rect"), DefaultVertexFormat.f_85815_), GuiRenderType::setShaderRoundRect);
            }
            catch (IOException e) {
                ModernUI.LOGGER.error(ModernUI.MARKER, "Bad round rect shader", (Throwable)e);
            }
        }

        static {
            boolean bl = $assertionsDisabled = !Registration.class.desiredAssertionStatus();
            if (!$assertionsDisabled && !FMLEnvironment.dist.isClient()) {
                throw new AssertionError();
            }
        }

        static class GuiScaleValueSet
        implements OptionInstance.IntRangeBase,
        OptionInstance.SliderableOrCyclableValueSet<Integer> {
            GuiScaleValueSet() {
            }

            public int m_214123_() {
                return 0;
            }

            public int m_214118_() {
                return 8;
            }

            @Nonnull
            public Integer m_213729_(double progress) {
                return Math.toIntExact(Math.round(Mth.m_144914_((double)progress, (double)0.0, (double)1.0, (double)this.m_214123_(), (double)this.m_214118_())));
            }

            @Nonnull
            public Optional<Integer> validateValue(@Nonnull Integer value) {
                return Optional.of(Mth.m_14045_((int)value, (int)this.m_214123_(), (int)this.m_214118_()));
            }

            @Nonnull
            public Codec<Integer> m_213664_() {
                return ExtraCodecs.m_264370_((Codec)Codec.INT, value -> {
                    int max = this.m_214118_() + 1;
                    if (value.compareTo(this.m_214123_()) >= 0 && value.compareTo(max) <= 0) {
                        return DataResult.success((Object)value);
                    }
                    return DataResult.error(() -> "Value " + value + " outside of range [" + this.m_214123_() + ":" + max + "]", (Object)value);
                });
            }

            @Nonnull
            public CycleButton.ValueListSupplier<Integer> m_213889_() {
                return CycleButton.ValueListSupplier.m_232504_(IntStream.range(this.m_214123_(), this.m_214118_() + 1).boxed().toList());
            }

            public boolean m_214105_() {
                return false;
            }
        }
    }
}

